<?php
require_once 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $invoice_id = $input['invoice_id'];
    $status = $input['status'];
    $payment_id = $input['payment_id'];
    
    try {
        $stmt = $pdo->prepare("UPDATE invoices SET status = ?, payment_id = ?, paid_at = NOW() WHERE id = ?");
        $stmt->execute([$status, $payment_id, $invoice_id]);
        
        echo json_encode(['success' => true, 'message' => 'Payment status updated']);
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
    }
}
?>