<?php
require_once '../config/database.php';

$invoice_id = $_GET['id'] ?? null;
if (!$invoice_id) {
    die('Invoice ID required');
}

$stmt = $pdo->prepare("SELECT i.*, u.company_name, u.address as user_address, u.phone as user_phone, u.gstin as user_gstin 
                      FROM invoices i 
                      LEFT JOIN users u ON i.user_id = u.id 
                      WHERE i.id = ?");
$stmt->execute([$invoice_id]);
$invoice = $stmt->fetch();

if (!$invoice) {
    die('Invoice not found');
}

// Get invoice items
$items_stmt = $pdo->prepare("SELECT * FROM invoice_items WHERE invoice_id = ?");
$items_stmt->execute([$invoice_id]);
$items = $items_stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice <?php echo $invoice['invoice_number']; ?></title>
    <style>
        body { font-family: Arial, sans-serif; margin: 0; padding: 20px; background: #f5f5f5; }
        .invoice-container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        .invoice-header { border-bottom: 2px solid #333; padding-bottom: 20px; margin-bottom: 30px; }
        .company-info h2 { margin: 0; color: #333; }
        .invoice-details { background: #f9f9f9; padding: 15px; border-radius: 5px; }
        .invoice-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        .invoice-table th { background: #333; color: white; padding: 12px; text-align: left; }
        .invoice-table td { padding: 12px; border-bottom: 1px solid #ddd; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .totals-table { width: 300px; margin-left: auto; }
        .status-paid { color: green; font-weight: bold; }
        .status-pending { color: orange; font-weight: bold; }
        .status-overdue { color: red; font-weight: bold; }
        @media print {
            body { background: white; }
            .invoice-container { box-shadow: none; padding: 0; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="invoice-header">
            <div style="display: flex; justify-content: between; align-items: center;">
                <div class="company-info">
                    <h2><?php echo htmlspecialchars($invoice['company_name'] ?: 'SM Tech Billing'); ?></h2>
                    <p><?php echo nl2br(htmlspecialchars($invoice['user_address'])); ?></p>
                    <?php if ($invoice['user_phone']): ?>
                        <p>Phone: <?php echo htmlspecialchars($invoice['user_phone']); ?></p>
                    <?php endif; ?>
                    <?php if ($invoice['user_gstin']): ?>
                        <p>GSTIN: <?php echo htmlspecialchars($invoice['user_gstin']); ?></p>
                    <?php endif; ?>
                </div>
                <div style="text-align: right;">
                    <h1>INVOICE</h1>
                    <p><strong>Invoice #:</strong> <?php echo $invoice['invoice_number']; ?></p>
                    <p><strong>Date:</strong> <?php echo date('d M Y', strtotime($invoice['invoice_date'])); ?></p>
                    <?php if ($invoice['due_date']): ?>
                        <p><strong>Due Date:</strong> <?php echo date('d M Y', strtotime($invoice['due_date'])); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div style="display: flex; justify-content: space-between; margin-bottom: 30px;">
            <div class="bill-to">
                <h3>Bill To:</h3>
                <p><strong><?php echo htmlspecialchars($invoice['client_name']); ?></strong></p>
                <p><?php echo nl2br(htmlspecialchars($invoice['client_address'])); ?></p>
                <?php if ($invoice['client_gstin']): ?>
                    <p>GSTIN: <?php echo htmlspecialchars($invoice['client_gstin']); ?></p>
                <?php endif; ?>
            </div>
            <div class="invoice-details">
                <p><strong>Status:</strong> 
                    <span class="status-<?php echo $invoice['status']; ?>">
                        <?php echo strtoupper($invoice['status']); ?>
                    </span>
                </p>
                <p><strong>Billing Type:</strong> 
                    <?php echo $invoice['billing_type'] == 'gst' ? 'GST' : 'Non-GST'; ?>
                </p>
            </div>
        </div>

        <table class="invoice-table">
            <thead>
                <tr>
                    <th>Description</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <?php if ($invoice['billing_type'] == 'gst'): ?>
                        <th>Tax Rate</th>
                    <?php endif; ?>
                    <th class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($items as $item): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($item['description']); ?></td>
                        <td><?php echo $item['quantity']; ?></td>
                        <td>₹<?php echo number_format($item['unit_price'], 2); ?></td>
                        <?php if ($invoice['billing_type'] == 'gst'): ?>
                            <td><?php echo $item['tax_rate']; ?>%</td>
                        <?php endif; ?>
                        <td class="text-right">₹<?php echo number_format($item['total'], 2); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <table class="totals-table">
            <tr>
                <td><strong>Subtotal:</strong></td>
                <td class="text-right">₹<?php echo number_format($invoice['subtotal'], 2); ?></td>
            </tr>
            <?php if ($invoice['billing_type'] == 'gst'): ?>
                <tr>
                    <td><strong>Tax Amount:</strong></td>
                    <td class="text-right">₹<?php echo number_format($invoice['tax_amount'], 2); ?></td>
                </tr>
            <?php endif; ?>
            <tr>
                <td><strong>Total Amount:</strong></td>
                <td class="text-right">₹<?php echo number_format($invoice['total_amount'], 2); ?></td>
            </tr>
        </table>

        <?php if ($invoice['notes']): ?>
            <div style="margin-top: 30px;">
                <h4>Notes:</h4>
                <p><?php echo nl2br(htmlspecialchars($invoice['notes'])); ?></p>
            </div>
        <?php endif; ?>

        <div style="margin-top: 50px; text-align: center; color: #666;">
            <p>Thank you for your business!</p>
        </div>

        <div class="no-print" style="margin-top: 30px; text-align: center;">
            <button onclick="window.print()" class="btn btn-primary">Print Invoice</button>
            <button onclick="downloadPDF(<?php echo $invoice_id; ?>)" class="btn btn-secondary">Download PDF</button>
            <button onclick="shareInvoice(<?php echo $invoice_id; ?>)" class="btn btn-info">Share via Email</button>
            <?php if ($invoice['status'] != 'paid'): ?>
                <button onclick="initiateRazorpayPayment(<?php echo $invoice_id; ?>, <?php echo $invoice['total_amount']; ?>)" 
                        class="payment-btn">Pay Now</button>
            <?php endif; ?>
        </div>
    </div>

    <script src="../assets/js/script.js"></script>
</body>
</html>